from flask import Blueprint, render_template, request, redirect, url_for
from . import db
from .models import User


main = Blueprint("main", __name__)


@main.route("/", methods=["GET"])
def index():
    return render_template("index.html")


@main.route("/submit", methods=["POST"])
def submit():
    username = request.form.get("username")
    email = request.form.get("email")

    new_user = User(username=username, email=email)
    db.session.add(new_user)
    db.session.commit()

    return redirect(url_for("main.result", username=username, email=email))


@main.route("/result", methods=["GET"])
def result():
    username = request.args.get("username")
    email = request.args.get("email")
    return f"User {username} with email {email} has been added to the database."
