"""
애플리케이션 전역 설정 모듈.

데이터 경로, 서버 바인딩, 공통 스타일 등을 한 곳에서 관리한다.
학습 포인트:
- 하드코딩을 피하고 설정을 중앙집중화하면 환경 변경에 유연해진다.
"""

from pathlib import Path

# CSV 데이터 경로 (프로젝트 루트 기준)
DATA_PATH: Path = Path(__file__).resolve().parent / "files" / "super_store_sales.csv"

# 서버 설정
HOST: str = "127.0.0.1"
PORT: int = 8050
DEBUG: bool = True

# 간단 공통 스타일 (Dash 인라인 스타일로 재사용)
APP_STYLES: dict[str, dict[str, str]] = {
    "container": {
        # maxWidth: 전체 레이아웃의 최대 너비(px 단위).
        #   -> 큰 화면에서 콘텐츠가 너무 넓게 퍼지는 것을 방지.
        "maxWidth": "1400px",
        # margin: 상하/좌우 여백.
        #   -> "0 auto": 위/아래 0, 좌우 자동(가운데 정렬)입니다.
        "margin": "0 auto",
        # fontFamily: 페이지 전반에 적용할 기본 폰트 패밀리
        # (우선순위가 앞쪽에 있는 폰트부터 사용).
        "fontFamily": "ui-sans-serif, system-ui"
    },
    "h2": {
        # h2 헤딩에 적용할 여백(상하 우/좌).
        #   -> "16px 8px"은 상하 16px, 좌우 8px
        "margin": "16px 8px"
    },
    "row": {
        # display: 행 컨테이너의 레이아웃 방식.
        # flex로 열 내부 아이템을 유연하게 배치
        "display": "flex",
        # gap: 행 내부 항목들 사이의 간격(수평/수직 모두 적용).
        "gap": "12px",
        # padding: 행 내부의 여백(컨텐츠와 테두리 사이 공간).
        "padding": "8px",
        # flexWrap: 항목이 한 줄에 다 들어가지 않을 때 줄바꿈 여부.
        #   -> 'wrap': 꽉 차면 다음 줄로 이동
        "flexWrap": "wrap"
    },
    "card": {
        # background: 카드 컴포넌트의 배경색
        # (예: 밝은 테마에서는 #fff).
        "background": "#fff",
        # padding: 카드 내부 콘텐츠와 테두리 간의 여백(상하 좌우).
        "padding": "12px 16px",
        # borderRadius: 카드 모서리의 둥글기(단위 px).
        "borderRadius": "12px",
        # boxShadow: 카드의 그림자 효과
        # (수평오프셋, 수직오프셋, 블러, 색상).
        "boxShadow": "0 1px 6px rgba(0,0,0,0.06)",
    },
}
