# Dash 커스터마이징 기록 (Kaggle 데이터셋 예시)

이 문서는 Kaggle에서 가져온 데이터셋으로 Plotly 대시보드를 구성할 때 참고할 수 있는 작업 노트 템플릿입니다.

## 데이터 소스 연결

- `config.py`
    ```python
    DATA_PATH = Path("./files/super_store_sales.csv")
    ```

- Kaggle 데이터 전처리 과정을 간단히 메모하고, 필요한 경우 `data/processed/` 폴더에 추가 산출물을 저장한다.

## KPI 카드 구성

- `services/callbacks.py`
```python
kpi_card("총 매출", f"{total_sales:,.0f}")
kpi_card("주요 고객 수", f"{total_quantity:,.0f}")
kpi_card("평균 거래 금액", f"{average_price:,.2f}")
```

- KPI 제목과 단위는 선택한 데이터셋 특성에 맞춰 조정한다. (예: 주문 수, 사용자 수, 클릭 수 등)

## 시각화 아이디어

- 시계열이 있다면 `px.line`으로 추세 분석 + 범위 슬라이더 추가

- 범주 비교는 `px.bar`/`px.treemap`으로 구성하고 hover에 점유율 표시

- 상관관계 탐색은 `px.scatter` 또는 `px.density_heatmap` 활용

- 지도 데이터인 경우 `px.choropleth`로 지역별 지표 비교

## 레이아웃 & 사용자 안내

- 필터(예: 연도, 지역, 카테고리)를 `dcc.Dropdown`으로 제공

- 대시보드 하단에 데이터 출처(Kaggle URL)와 업데이트 주기를 명시

- 색상 팔레트는 데이터 의미에 맞춰 3~5색 이내로 유지

## 실행 메모

```bash
cd plotly_porject
python3 app.py
```

- 가상환경 사용 시 `python -m venv venv` → `source venv/bin/activate` → `pip install -r requirements.txt`
