# Chap12 Homework Reference

이 디렉터리는 `Advanced Visualization` 과제 수행 시 참고할 수 있는 작업 예시를 담고 있습니다.  
과제 요구 사항은 *Kaggle 데이터셋*을 활용해 Plotly 기반 대시보드를 제작하고, 결과를 정리하여 제출하는 것입니다.

## 1. Kaggle 데이터 다운로드

1. Kaggle의 <a href="https://www.kaggle.com/datasets/rohitsahoo/sales-forecasting?resource=download" target="_blank" rel="noopener noreferrer">Superstore Sales Dataset</a>을 다운로드합니다.  
2. 또는 로컬 예제 파일을 사용할 수 있습니다: <a href="../homeworks/super_store_sales.csv" download>super_store_sales.csv</a>  
3. 데이터 사용 조건(라이선스, 출처 표기)을 확인하고 Rohit Sahoo, 2017을 인용합니다.  
4. 필요한 전처리를 수행한 뒤 아래 핵심 컬럼을 남기고 `solution/files/` 폴더에 CSV 형태로 저장합니다. (예: `solution/files/super_store_sales.csv`)

    - 차원: `Order Date`(연-월 변환), `Region`, `State`, `Category`, `Sub-Category`, `Segment`

    - 측정값: 최소 `Sales` (가능하면 `Profit`, `Quantity`, `Discount`도 유지)

## 2. Plotly 대시보드 구성

1. `plotly_project.zip`을 압축 해제하거나 `plotly_porject` 디렉터리를 복사합니다.  
2. `config.py`의 `DATA_PATH`를 `./files/super_store_sales.csv`(혹은 본인이 저장한 경로)로 지정합니다.
3. 최소 3종 이상의 차트를 구성하고, 필터/상호작용을 포함해 사용자가 데이터를 탐색할 수 있도록 설계합니다.  
4. `dashboard_custom_notes.md`에 시각화 구성 노트를 기록하며 진행합니다.

## 3. 결과 요약 및 제출

1. 완성된 대시보드 화면을 캡처하고, `insight_summary.md` 예시처럼 주요 인사이트를 정리합니다.  
2. 프로젝트 전체를 `.zip`으로 압축하고, 실행 방법(`python -m venv`, `pip install -r requirements.txt`, `python app.py`)을 `README.md`로 제공해 제출합니다.

## 참고 파일

- `dashboard_custom_notes.md` : 대시보드 구성 아이디어 및 수정 내역 기록 예시  
- `insight_summary.md` : 인사이트 보고 예시 템플릿
